//
//  KeychainItem.h
//  Keychain
//
//  Created by Wade Tregaskis on Fri Jan 24 2003.
//  Copyright (c) 2003 Wade Tregaskis. All rights reserved.
//

#import "NSCachedObject.h"
#import <Foundation/Foundation.h>
#import <Security/Security.h>
#import "Access.h"


@class Certificate;
@class Keychain;


@interface KeychainItem : NSCachedObject {
    SecKeychainItemRef keychainItem;
    int error;
}

+ (KeychainItem*)keychainItemWithKeychainItemRef:(SecKeychainItemRef)keychainIt;

- (KeychainItem*)initWithKeychainItemRef:(SecKeychainItemRef)keychainIt;

- (SecItemClass)kind;
- (NSString*)kindString;
- (BOOL)isInternetItem;
- (BOOL)isGenericItem;
- (BOOL)isAppleShareItem;
- (BOOL)isCertificate;

- (void)setData:(NSData*)data;
- (void)setDataString:(NSString*)data;
- (NSData*)data;
- (NSString*)dataAsString;

- (void)setCreationDate:(NSCalendarDate*)date;
- (void)setModificationDate:(NSCalendarDate*)date;
- (void)setDescription:(NSString*)desc;
- (void)setComment:(NSString*)comment;
- (void)setCreator:(NSString*)creator;
- (void)setType:(NSString*)type;
- (void)setLabel:(NSString*)label;
- (void)setIsVisible:(BOOL)visible;
- (void)setIsValid:(BOOL)valid;
- (void)setHasCustomIcon:(BOOL)icon;
- (void)setAccount:(NSString*)account;
- (void)setService:(NSString*)service;
- (void)setAttribute:(NSString*)attribute;
- (void)setDomain:(NSString*)domain;
- (void)setServer:(NSString*)server;
- (void)setAuthenticationType:(SecAuthenticationType)authType;
- (void)setPort:(UInt16)port;
- (void)setPath:(NSString*)path;
- (void)setAppleShareVolume:(NSString*)volume;
- (void)setAppleShareAddress:(NSString*)address;
- (void)setAppleShareSignature:(SecAFPServerSignature*)sig;
- (void)setProtocol:(SecProtocolType)protocol;
- (void)setCertificateType:(CSSM_CERT_TYPE)certType;
- (void)setCertificateEncoding:(CSSM_CERT_ENCODING)certEncoding;
- (void)setCRLtype:(CSSM_CRL_TYPE)type;
- (void)setCRLencoding:(CSSM_CRL_ENCODING)encoding;
- (void)setIsAlias:(BOOL)alias;

- (NSCalendarDate*)creationDate;
- (NSCalendarDate*)modificationDate;
- (NSString*)description;
- (NSString*)comment;
- (NSString*)creator;
- (NSString*)type;
- (NSString*)label;
- (BOOL)isVisible;
- (BOOL)passwordIsValid;
- (BOOL)hasCustomIcon;
- (NSString*)account;
- (NSString*)service;
- (NSString*)attribute;
- (NSString*)domain;
- (NSString*)server;
- (SecAuthenticationType)authenticationType;
- (NSString*)authenticationTypeString;
- (UInt16)port;
- (NSString*)path;
- (NSString*)appleShareVolume;
- (NSString*)appleShareAddress;
- (SecAFPServerSignature*)appleShareSignature;
- (NSData*)appleShareSignatureData;
- (SecProtocolType)protocol;
- (NSString*)protocolString;
- (CSSM_CERT_TYPE)certificateType;
- (NSString*)certificateTypeString;
- (CSSM_CERT_ENCODING)certificateEncoding;
- (NSString*)certificateEncodingString;
- (CSSM_CRL_TYPE)CRLtype;
- (NSString*)CRLtypeString;
- (CSSM_CRL_ENCODING)CRLencoding;
- (NSString*)CRLencodingString;
- (BOOL)isAlias;

- (void)setAccess:(Access*)acc;
- (Access*)access;

- (Keychain*)keychain;

- (KeychainItem*)createDuplicate;

- (Certificate*)certificate;

- (void)deleteCompletely;

- (int)lastError;
- (SecKeychainItemRef)keychainItemRef;

@end
